
Partial Class SearchCustomers
    Inherits ApplicationBasePage

#Region " Declare Privates "

    Public _SearchPerformed As Boolean = False
    Private _StopWatch As New System.Diagnostics.Stopwatch()

#End Region

#Region " Handled Events "

    Protected Sub lstResults_AfterRequery() Handles lstResults.AfterRequery
        lblResultsHeader.Text = Customers.Count.ToString("n0") & " Results Found in " & _StopWatch.Elapsed.TotalSeconds.ToString() & " seconds"
    End Sub

    Protected Sub lstResults_ListPopulating(ByVal e As MicroFour.StrataFrame.UI.ListPopulatingEventArgs) Handles lstResults.ListPopulating
        lstResults.Rows.Clear()
        e.Parameters(0).Value = Customers
        e.Parameters(1).Value = MicroFour.StrataFrame.Business.BusinessCloneDataType.ClearAndFillFromDefaultView
    End Sub

    Protected Sub lstResults_RowPopulating(ByVal e As MicroFour.StrataFrame.UI.Web.RowPopulatingEventArgs) Handles lstResults.RowPopulating
        e.Values(0).DisplayValue = "<a href='editcustomers.aspx?pk=" & e.BusinessObject.Item("cust_pk").ToString() & "'>Edit</a>"
    End Sub

    Protected Sub cmdClear_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdClear.Click
        '-- Clear the text boxes
        txtFirstName.Text = ""
        txtLastName.Text = ""
    End Sub

    Protected Sub cmdSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdSearch.Click
        '-- Execute the search
        ExecuteSearch()
    End Sub

#End Region

#Region " Search Methods "

    ''' <summary>
    ''' Executes the search
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub ExecuteSearch()
        '-- Establish Locals
        Dim loCommand As New System.Data.SqlClient.SqlCommand()
        Dim lcWhere As String = " WHERE "
        Dim llHadWhere As Boolean = False

        '-- Reset and start the stop watch
        _StopWatch.Reset()
        _StopWatch.Start()

        '-- Build the select
        loCommand.CommandText = "SELECT TOP 100 * FROM customers "

        '-- Build the WHERE clause
        If txtFirstName.Text.Length > 0 Then
            '-- Indicate that a statement has been added
            llHadWhere = True

            '-- Update the WHERE command
            lcWhere &= "cust_FirstName LIKE @cust_FirstName"

            '-- Add the parameter
            loCommand.Parameters.Add("@cust_FirstName", Data.SqlDbType.VarChar)
            loCommand.Parameters("@cust_FirstName").Value = txtFirstName.Text & "%"
        End If

        '-- Check the last name
        If txtLastName.Text.Length > 0 Then
            '-- See if an AND needs to the added
            If llHadWhere Then
                lcWhere &= " AND "
            End If

            '-- Indicate that a statement has been added
            llHadWhere = True

            '-- Update the WHERE command
            lcWhere &= "cust_LastName LIKE @cust_LastName"

            '-- Add the parameter
            loCommand.Parameters.Add("@cust_LastName", Data.SqlDbType.VarChar)
            loCommand.Parameters("@cust_LastName").Value = txtLastName.Text & "%"
        End If

        '-- Update the command
        If llHadWhere Then
            loCommand.CommandText &= lcWhere
        End If

        '-- Set the order
        loCommand.CommandText &= " ORDER BY cust_LastName, cust_FirstName"

        '-- Execute the command
        Customers.FillDataTable(loCommand)

        '-- Stop the watch
        _StopWatch.Stop()

        '-- Set the search flag
        Me._SearchPerformed = True

        '-- Load the results display
        SetResultsDisplay()
    End Sub

    ''' <summary>
    ''' Set the results display
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetResultsDisplay()
        '-- Set the results display
        If Me.Customers.Count = 0 Then
            Me.lblResults.Text = "No Results Found"
            Me.lblResults.Visible = True
        Else
            Me.lblResults.Visible = False
            Me.lstResults.Visible = True
            Me.lstResults.Requery()
        End If
    End Sub

#End Region

End Class
